# Contribution Guide

The contribution guide is for those who want to contribute to the Siren RPG project, but have no idea where to start.

This guide is here to help!

First off, you need a GitHub account to contribute (sorry).
You can join GitHub [here](https://github.com/join).

## Before You Contribute

Read through the premise guide on the front page of the project.
The contributions should be sensible and not bloat the game with /unnecessary/ extra features.
If you love a feature enough, but it's a bit too setting-specific, consider turning it into a setting or adventure which makes use of Siren.

## Something is unclear / I want to request a feature

That's what the [issues tab](https://github.com/ElectricCoffee/SirenRPG/issues) is for.
Hit look around and see if your question/issue has already been addressed, and if not, go ahead and post the question.

I'll have a look and see what the issue might be.
If anything, your idea might actually get added!

## I want to contribute directly

If you want to contribute directly to the source of the project, you have to do a few things:

1. Make a _fork_ of the project
2. Make your changes to the fork
3. Make sure it actually compiles and produces a usable PDF
4. Submit a [pull request](https://github.com/ElectricCoffee/SirenRPG/pulls)

Then I'll review it, we can discuss it, make changes to it, and then when everything is perfect, it'll be pulled into the project and become part of Siren.

**NOTE** Make sure to make the pull request against `develop` instead of `master`.
This is important as it won't interfere with the normal release cycle.
